var __extends = this.__extends || function (d, b) {
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var MemoryAnalyzer;
(function (MemoryAnalyzer) {
    ; ;
    (function (HeapObjectFlags) {
        HeapObjectFlags._map = [];
        HeapObjectFlags.IsNewOffset = 0;
        HeapObjectFlags.IsNewMask = 3;
        HeapObjectFlags.ExternalOffset = 2;
        HeapObjectFlags.ExternalMask = 7;
        HeapObjectFlags.WinRtOffset = 5;
        HeapObjectFlags.WinRtMask = 7;
        HeapObjectFlags.IsRoot = 1 << 8;
        HeapObjectFlags.IsSiteClosed = 1 << 9;
        HeapObjectFlags.IsBuiltIn = 1 << 10;
        HeapObjectFlags.IsMarkup = 1 << 11;
        HeapObjectFlags.IsSizeApproximate = 1 << 12;
    })(MemoryAnalyzer.HeapObjectFlags || (MemoryAnalyzer.HeapObjectFlags = {}));
    var HeapObjectFlags = MemoryAnalyzer.HeapObjectFlags;
    (function (ExternalObjectKind) {
        ExternalObjectKind._map = [];
        ExternalObjectKind.Default = 1;
        ExternalObjectKind.Unknown = 2;
        ExternalObjectKind.Dispatch = 3;
    })(MemoryAnalyzer.ExternalObjectKind || (MemoryAnalyzer.ExternalObjectKind = {}));
    var ExternalObjectKind = MemoryAnalyzer.ExternalObjectKind;
    (function (WinRTObjectKind) {
        WinRTObjectKind._map = [];
        WinRTObjectKind.Instance = 1;
        WinRTObjectKind.RuntimeClass = 2;
        WinRTObjectKind.Delegate = 3;
        WinRTObjectKind.Namespace = 4;
    })(MemoryAnalyzer.WinRTObjectKind || (MemoryAnalyzer.WinRTObjectKind = {}));
    var WinRTObjectKind = MemoryAnalyzer.WinRTObjectKind;
    var MaskOperations = (function () {
        function MaskOperations() { }
        MaskOperations.getValue = function getValue(input, offset, mask) {
            return (input >> offset) & mask;
        }
        MaskOperations.setValue = function setValue(input, newValue, offset, mask) {
            return (~(mask << offset) & input) | ((newValue & mask) << offset);
        }
        MaskOperations.isFlagSet = function isFlagSet(input, flag) {
            return (input & flag) !== 0 ? true : false;
        }
        MaskOperations.setFlag = function setFlag(input, newValue, flag) {
            return newValue ? (input | flag) : (input & (~flag));
        }
        return MaskOperations;
    })();
    MemoryAnalyzer.MaskOperations = MaskOperations;    
    var HeapObject = (function () {
        function HeapObject(objectId) {
            this.objectId = objectId;
        }
        Object.defineProperty(HeapObject.prototype, "kind", {
            get: function () {
                return this["__kind"];
            },
            set: function (v) {
                this["__kind"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "type", {
            get: function () {
                return this["__type"];
            },
            set: function (v) {
                this["__type"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "identifierList", {
            get: function () {
                return this["__identifierList"];
            },
            set: function (v) {
                this["__identifierList"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "prototype", {
            get: function () {
                return this["__prototype"];
            },
            set: function (v) {
                this["__prototype"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "functionName", {
            get: function () {
                return this["__functionName"];
            },
            set: function (v) {
                this["__functionName"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "value", {
            get: function () {
                return this["__value"];
            },
            set: function (v) {
                this["__value"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "size", {
            get: function () {
                return this["__size"];
            },
            set: function (v) {
                this["__size"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "sizeIsApproximate", {
            get: function () {
                return MaskOperations.isFlagSet(this._flags, HeapObjectFlags.IsSizeApproximate);
            },
            set: function (v) {
                this._flags = MaskOperations.setFlag(this._flags, v, HeapObjectFlags.IsSizeApproximate);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "retainedSize", {
            get: function () {
                return this["__retainedSize"];
            },
            set: function (v) {
                this["__retainedSize"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "isNew", {
            get: function () {
                var val = MaskOperations.getValue(this._flags, HeapObjectFlags.IsNewOffset, HeapObjectFlags.IsNewMask);
                return val === 0 ? undefined : (val === 1 ? false : true);
            },
            set: function (v) {
                var isNewVal = v ? 2 : (v === null ? 0 : 1);
                this._flags = MaskOperations.setValue(this._flags, isNewVal, HeapObjectFlags.IsNewOffset, HeapObjectFlags.IsNewMask);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "isRoot", {
            get: function () {
                return MaskOperations.isFlagSet(this._flags, HeapObjectFlags.IsRoot);
            },
            set: function (v) {
                this._flags = MaskOperations.setFlag(this._flags, v, HeapObjectFlags.IsRoot);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "isSiteClosed", {
            get: function () {
                return MaskOperations.isFlagSet(this._flags, HeapObjectFlags.IsSiteClosed);
            },
            set: function (v) {
                this._flags = MaskOperations.setFlag(this._flags, v, HeapObjectFlags.IsSiteClosed);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "isBuiltIn", {
            get: function () {
                return MaskOperations.isFlagSet(this._flags, HeapObjectFlags.IsBuiltIn);
            },
            set: function (v) {
                this._flags = MaskOperations.setFlag(this._flags, v, HeapObjectFlags.IsBuiltIn);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "external", {
            get: function () {
                var val = MaskOperations.getValue(this._flags, HeapObjectFlags.ExternalOffset, HeapObjectFlags.ExternalMask);
                return val ? val : undefined;
            },
            set: function (v) {
                var newVal = v ? v : 0;
                this._flags = MaskOperations.setValue(this._flags, newVal, HeapObjectFlags.ExternalOffset, HeapObjectFlags.ExternalMask);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "winrt", {
            get: function () {
                var val = MaskOperations.getValue(this._flags, HeapObjectFlags.WinRtOffset, HeapObjectFlags.WinRtMask);
                return val ? val : undefined;
            },
            set: function (v) {
                var newVal = v ? v : 0;
                this._flags = MaskOperations.setValue(this._flags, newVal, HeapObjectFlags.WinRtOffset, HeapObjectFlags.WinRtMask);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "isMarkup", {
            get: function () {
                return MaskOperations.isFlagSet(this._flags, HeapObjectFlags.IsMarkup);
            },
            set: function (v) {
                this._flags = MaskOperations.setFlag(this._flags, v, HeapObjectFlags.IsMarkup);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "elementAttributesSize", {
            get: function () {
                return this["__elementAttributesSize"];
            },
            set: function (v) {
                this["__elementAttributesSize"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "elementTextChildrenSize", {
            get: function () {
                return this["__elementTextChildrenSize"];
            },
            set: function (v) {
                this["__elementTextChildrenSize"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "properties", {
            get: function () {
                return this["__properties"];
            },
            set: function (v) {
                this["__properties"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "indices", {
            get: function () {
                return this["__indices"];
            },
            set: function (v) {
                this["__indices"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "scopes", {
            get: function () {
                return this["__scopes"];
            },
            set: function (v) {
                this["__scopes"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "relationships", {
            get: function () {
                return this["__relationships"];
            },
            set: function (v) {
                this["__relationships"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "events", {
            get: function () {
                return this["__events"];
            },
            set: function (v) {
                this["__events"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "internalProperties", {
            get: function () {
                return this["__internalProperties"];
            },
            set: function (v) {
                this["__internalProperties"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "parents", {
            get: function () {
                return this["__parents"];
            },
            set: function (v) {
                this["__parents"] = v;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "isChanged", {
            get: function () {
                var thisAsChanged = this;
                return thisAsChanged.isNew || (!isNaN(thisAsChanged.sizeDiff) && thisAsChanged.sizeDiff !== 0);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HeapObject.prototype, "isRelatedToChanged", {
            get: function () {
                var thisAsChanged = this;
                return !this.isChanged && thisAsChanged.isChangedAncestor;
            },
            enumerable: true,
            configurable: true
        });
        HeapObject.prototype.copyFrom = function (sourceObject) {
            for(var key in sourceObject) {
                (this)[key] = (sourceObject)[key];
            }
        };
        return HeapObject;
    })();
    MemoryAnalyzer.HeapObject = HeapObject;    
    var ValueHeapObject = (function (_super) {
        __extends(ValueHeapObject, _super);
        function ValueHeapObject(ownerObject, prop, pointerSize) {
                _super.call(this, ValueHeapObject.ValueHeapObjectId);
            if(typeof prop.stringValue !== "undefined") {
                this.kind = "String";
                this.value = prop.stringValue;
            } else {
                if(typeof prop.numberValue !== "undefined") {
                    this.kind = "Number";
                    this.value = prop.numberValue;
                } else {
                    throw new Error(Plugin.Resources.getErrorString("JSPerf.1001"));
                }
            }
            this.size = MemoryAnalyzer.HeapObjectHelpers.getValuePropSize(prop, pointerSize);
            this.retainedSize = this.size;
            this.type = this.kind;
            var thisAsChanged = this;
            if((prop).isNew) {
                thisAsChanged.isNew = true;
            } else {
                thisAsChanged.isNew = ownerObject.isNew;
            }
        }
        ValueHeapObject.ValueHeapObjectId = -1;
        return ValueHeapObject;
    })(HeapObject);
    MemoryAnalyzer.ValueHeapObject = ValueHeapObject;    
    var NamedHeapObject = (function () {
        function NamedHeapObject(innerObj, hasChildrenWhenFiltered, displayObjectIDs, nameOverride) {
            this._innerObj = innerObj;
            this._hasChildrenWhenFiltered = hasChildrenWhenFiltered;
            this.name = this.initName(nameOverride, displayObjectIDs);
        }
        Object.defineProperty(NamedHeapObject.prototype, "id", {
            get: function () {
                return this.objectId;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "objectId", {
            get: function () {
                return this._innerObj.objectId;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "kind", {
            get: function () {
                return this._innerObj.kind;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "type", {
            get: function () {
                return this._innerObj.type;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "identifierList", {
            get: function () {
                return this._innerObj.identifierList;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "prototype", {
            get: function () {
                return this._innerObj.prototype;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "functionName", {
            get: function () {
                return this._innerObj.functionName;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "value", {
            get: function () {
                return this._innerObj.value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "size", {
            get: function () {
                return this._innerObj.size;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "sizeIsApproximate", {
            get: function () {
                return this._innerObj.sizeIsApproximate;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "retainedSize", {
            get: function () {
                return this._innerObj.retainedSize;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "isNew", {
            get: function () {
                return this._innerObj.isNew;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "isRoot", {
            get: function () {
                return this._innerObj.isRoot;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "isSiteClosed", {
            get: function () {
                return this._innerObj.isSiteClosed;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "isBuiltIn", {
            get: function () {
                return this._innerObj.isBuiltIn;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "external", {
            get: function () {
                return this._innerObj.external;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "winrt", {
            get: function () {
                return this._innerObj.winrt;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "isMarkup", {
            get: function () {
                return this._innerObj.isMarkup;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "elementAttributesSize", {
            get: function () {
                return this._innerObj.elementAttributesSize;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "elementTextChildrenSize", {
            get: function () {
                return this._innerObj.elementTextChildrenSize;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "properties", {
            get: function () {
                return this._innerObj.properties;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "indices", {
            get: function () {
                return this._innerObj.indices;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "scopes", {
            get: function () {
                return this._innerObj.scopes;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "relationships", {
            get: function () {
                return this._innerObj.relationships;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "events", {
            get: function () {
                return this._innerObj.events;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "internalProperties", {
            get: function () {
                return this._innerObj.internalProperties;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "parents", {
            get: function () {
                return this._innerObj.parents;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "isChanged", {
            get: function () {
                return (this._innerObj).isChanged;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "isRelatedToChanged", {
            get: function () {
                return (this._innerObj).isRelatedToChanged;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "sizeDiff", {
            get: function () {
                return (this._innerObj).sizeDiff;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "retainedSizeDiff", {
            get: function () {
                return (this._innerObj).retainedSizeDiff;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NamedHeapObject.prototype, "hasChildrenWhenFiltered", {
            get: function () {
                return this._hasChildrenWhenFiltered;
            },
            enumerable: true,
            configurable: true
        });
        NamedHeapObject.prototype.initName = function (nameOverride, displayObjectIDs) {
            var name;
            if(this.isRelatedToChanged) {
                name += "# ";
            }
            if(nameOverride) {
                name = nameOverride;
            } else {
                if(this.functionName) {
                    name = this.functionName;
                } else {
                    if(this.identifierList) {
                        name = this.identifierList.join(", ");
                    } else {
                        var tagName = MemoryAnalyzer.HeapObjectHelpers.getTagIdName(this);
                        if(tagName) {
                            name = tagName;
                        } else {
                            name = "";
                        }
                    }
                }
            }
            if(this.kind === "Window") {
                var windowLocation = MemoryAnalyzer.HeapObjectHelpers.getRelationshipStringValueWithName(this, "window location");
                if(windowLocation) {
                    if(name) {
                        name += " ";
                    } else {
                        name = "";
                    }
                    name += "[" + windowLocation + "]";
                }
            }
            if(this.winrt) {
                switch(this.winrt) {
                    case 2: {
                        name += "{Runtime Class} ";
                        break;

                    }
                    case 3: {
                        name += "{Delegate} ";
                        break;

                    }
                    case 4: {
                        name += "{Namespace} ";
                        break;

                    }
                }
            }
            if(this.external) {
                if(name) {
                    name += ": ";
                } else {
                    name = "";
                }
                var externalPostfix = "External";
                switch(this.external) {
                    case 2: {
                        externalPostfix += " IUnknown";
                        break;

                    }
                    case 3: {
                        externalPostfix += " IDispatch";
                        break;

                    }
                }
                name += externalPostfix;
            }
            if(typeof this.value !== "undefined") {
                if(name) {
                    name += " = ";
                } else {
                    name = "";
                }
                var isString = typeof (this.value) === "string";
                if(isString) {
                    name += "\"";
                }
                name += this.value;
                if(isString) {
                    name += "\"";
                }
            }
            if(name === "" && this.type) {
                name += "(" + this.type + ") ";
            }
            if(displayObjectIDs && this.objectId && this.objectId !== ValueHeapObject.ValueHeapObjectId) {
                name += " @" + this.objectId;
            }
            return name;
        };
        return NamedHeapObject;
    })();
    MemoryAnalyzer.NamedHeapObject = NamedHeapObject;    
    var ReferenceDataObject = (function (_super) {
        __extends(ReferenceDataObject, _super);
        function ReferenceDataObject(innerObj, displayObjectIDs, parentObjectId, nameOverride, hasParentsWhenFiltered) {
                _super.call(this, innerObj, (typeof parentObjectId !== "undefined" && hasParentsWhenFiltered), displayObjectIDs, nameOverride);
            this.parentObjectId = parentObjectId;
            this.nameOverride = nameOverride;
        }
        return ReferenceDataObject;
    })(NamedHeapObject);
    MemoryAnalyzer.ReferenceDataObject = ReferenceDataObject;    
    var TypeDataObject = (function () {
        function TypeDataObject(typeName, objectHeapType, filteredChildrenCount, filteredChildrenCountDiff) {
            this._typeName = typeName;
            this.objectHeapType = objectHeapType;
            this._filteredChildrenCount = filteredChildrenCount;
            this._filteredChildrenCountDiff = filteredChildrenCountDiff;
        }
        Object.defineProperty(TypeDataObject.prototype, "isChanged", {
            get: function () {
                return this._filteredChildrenCountDiff > 0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TypeDataObject.prototype, "id", {
            get: function () {
                return this.name;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TypeDataObject.prototype, "name", {
            get: function () {
                return this._typeName;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TypeDataObject.prototype, "isRelatedToChanged", {
            get: function () {
                return false;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TypeDataObject.prototype, "retainedSize", {
            get: function () {
                return 0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TypeDataObject.prototype, "size", {
            get: function () {
                return this.objectHeapType.size;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TypeDataObject.prototype, "sizeIsApproximate", {
            get: function () {
                return false;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TypeDataObject.prototype, "isNew", {
            get: function () {
                return true;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TypeDataObject.prototype, "type", {
            get: function () {
                return this._typeName;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TypeDataObject.prototype, "isBuiltIn", {
            get: function () {
                return false;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TypeDataObject.prototype, "childrenCount", {
            get: function () {
                return this._filteredChildrenCount;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TypeDataObject.prototype, "childrenCountDiff", {
            get: function () {
                return this._filteredChildrenCountDiff;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TypeDataObject.prototype, "hasChildrenWhenFiltered", {
            get: function () {
                return this._filteredChildrenCount > 0;
            },
            enumerable: true,
            configurable: true
        });
        return TypeDataObject;
    })();
    MemoryAnalyzer.TypeDataObject = TypeDataObject;    
})(MemoryAnalyzer || (MemoryAnalyzer = {}));
//@ sourceMappingURL=heapObject.js.map

// SIG // Begin signature block
// SIG // MIIakQYJKoZIhvcNAQcCoIIagjCCGn4CAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFLiTnUDsMbsR
// SIG // Zi8uoGRGbmEV16WgoIIVeTCCBLowggOioAMCAQICCmEC
// SIG // jkIAAAAAAB8wDQYJKoZIhvcNAQEFBQAwdzELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBMB4XDTEyMDEwOTIyMjU1OFoXDTEz
// SIG // MDQwOTIyMjU1OFowgbMxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // DTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIg
// SIG // RFNFIEVTTjpGNTI4LTM3NzctOEE3NjElMCMGA1UEAxMc
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgU2VydmljZTCCASIw
// SIG // DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJbsjkdN
// SIG // VMJclYDXTgs9v5dDw0vjYGcRLwFNDNjRRi8QQN4LpFBS
// SIG // EogLQ3otP+5IbmbHkeYDym7sealqI5vNYp7NaqQ/56ND
// SIG // /2JHobS6RPrfQMGFVH7ooKcsQyObUh8yNfT+mlafjWN3
// SIG // ezCeCjOFchvKSsjMJc3bXREux7CM8Y9DSEcFtXogC+Xz
// SIG // 78G69LPYzTiP+yGqPQpthRfQyueGA8Azg7UlxMxanMTD
// SIG // 2mIlTVMlFGGP+xvg7PdHxoBF5jVTIzZ3yrDdmCs5wHU1
// SIG // D92BTCE9djDFsrBlcylIJ9jC0rCER7t4utV0A97XSxn3
// SIG // U9542ob3YYgmM7RHxqBUiBUrLHUCAwEAAaOCAQkwggEF
// SIG // MB0GA1UdDgQWBBQv6EbIaNNuT7Ig0N6JTvFH7kjB8jAf
// SIG // BgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7syuwwzWzDzBU
// SIG // BgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vY3JsLm1pY3Jv
// SIG // c29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsGAQUFBwEBBEww
// SIG // SjBIBggrBgEFBQcwAoY8aHR0cDovL3d3dy5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRUaW1lU3Rh
// SIG // bXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsGAQUFBwMIMA0G
// SIG // CSqGSIb3DQEBBQUAA4IBAQBz/30unc2NiCt8feNeFXHp
// SIG // aGLwCLZDVsRcSi1o2PlIEZHzEZyF7BLUVKB1qTihWX91
// SIG // 7sb1NNhUpOLQzHyXq5N1MJcHHQRTLDZ/f/FAHgybgOIS
// SIG // CiA6McAHdWfg+jSc7Ij7VxzlWGIgkEUvXUWpyI6zfHJt
// SIG // ECfFS9hvoqgSs201I2f6LNslLbldsR4F50MoPpwFdnfx
// SIG // Jd4FRxlt3kmFodpKSwhGITWodTZMt7MIqt+3K9m+Kmr9
// SIG // 3zUXzD8Mx90Gz06UJGMgCy4krl9DRBJ6XN0326RFs5E6
// SIG // Eld940fGZtPPnEZW9EwHseAMqtX21Tyi4LXU+Bx+BFUQ
// SIG // axj0kc1Rp5VlMIIE7DCCA9SgAwIBAgITMwAAALARrwqL
// SIG // 0Duf3QABAAAAsDANBgkqhkiG9w0BAQUFADB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQTAeFw0xMzAxMjQyMjMzMzla
// SIG // Fw0xNDA0MjQyMjMzMzlaMIGDMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYDVQQDExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24wggEiMA0GCSqGSIb3DQEB
// SIG // AQUAA4IBDwAwggEKAoIBAQDor1yiIA34KHy8BXt/re7r
// SIG // dqwoUz8620B9s44z5lc/pVEVNFSlz7SLqT+oN+EtUO01
// SIG // Fk7vTXrbE3aIsCzwWVyp6+HXKXXkG4Unm/P4LZ5BNisL
// SIG // QPu+O7q5XHWTFlJLyjPFN7Dz636o9UEVXAhlHSE38Cy6
// SIG // IgsQsRCddyKFhHxPuRuQsPWj/ov0DJpOoPXJCiHiquMB
// SIG // Nkf9L4JqgQP1qTXclFed+0vUDoLbOI8S/uPWenSIZOFi
// SIG // xCUuKq6dGB8OHrbCryS0DlC83hyTXEmmebW22875cHso
// SIG // AYS4KinPv6kFBeHgD3FN/a1cI4Mp68fFSsjoJ4TTfsZD
// SIG // C5UABbFPZXHFAgMBAAGjggFgMIIBXDATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzAdBgNVHQ4EFgQUWXGmWjNN2pgHgP+E
// SIG // Hr6H+XIyQfIwUQYDVR0RBEowSKRGMEQxDTALBgNVBAsT
// SIG // BE1PUFIxMzAxBgNVBAUTKjMxNTk1KzRmYWYwYjcxLWFk
// SIG // MzctNGFhMy1hNjcxLTc2YmMwNTIzNDRhZDAfBgNVHSME
// SIG // GDAWgBTLEejK0rQWWAHJNy4zFha5TJoKHzBWBgNVHR8E
// SIG // TzBNMEugSaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NybC9wcm9kdWN0cy9NaWNDb2RTaWdQQ0Ff
// SIG // MDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUHAQEETjBMMEoG
// SIG // CCsGAQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NlcnRzL01pY0NvZFNpZ1BDQV8wOC0zMS0y
// SIG // MDEwLmNydDANBgkqhkiG9w0BAQUFAAOCAQEAMdduKhJX
// SIG // M4HVncbr+TrURE0Inu5e32pbt3nPApy8dmiekKGcC8N/
// SIG // oozxTbqVOfsN4OGb9F0kDxuNiBU6fNutzrPJbLo5LEV9
// SIG // JBFUJjANDf9H6gMH5eRmXSx7nR2pEPocsHTyT2lrnqkk
// SIG // hNrtlqDfc6TvahqsS2Ke8XzAFH9IzU2yRPnwPJNtQtjo
// SIG // fOYXoJtoaAko+QKX7xEDumdSrcHps3Om0mPNSuI+5PNO
// SIG // /f+h4LsCEztdIN5VP6OukEAxOHUoXgSpRm3m9Xp5QL0f
// SIG // zehF1a7iXT71dcfmZmNgzNWahIeNJDD37zTQYx2xQmdK
// SIG // Dku/Og7vtpU6pzjkJZIIpohmgjCCBbwwggOkoAMCAQIC
// SIG // CmEzJhoAAAAAADEwDQYJKoZIhvcNAQEFBQAwXzETMBEG
// SIG // CgmSJomT8ixkARkWA2NvbTEZMBcGCgmSJomT8ixkARkW
// SIG // CW1pY3Jvc29mdDEtMCsGA1UEAxMkTWljcm9zb2Z0IFJv
// SIG // b3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5MB4XDTEwMDgz
// SIG // MTIyMTkzMloXDTIwMDgzMTIyMjkzMloweTELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWljcm9zb2Z0IENv
// SIG // ZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqGSIb3DQEBAQUA
// SIG // A4IBDwAwggEKAoIBAQCycllcGTBkvx2aYCAgQpl2U2w+
// SIG // G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/3sJCTiPVcgDb
// SIG // NVcKicquIEn08GisTUuNpb15S3GbRwfa/SXfnXWIz6pz
// SIG // RH/XgdvzvfI2pMlcRdyvrT3gKGiXGqelcnNW8ReU5P01
// SIG // lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJpL9oZC/6SdCni
// SIG // di9U3RQwWfjSjWL9y8lfRjFQuScT5EAwz3IpECgixzdO
// SIG // PaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn0i1i8UU956wI
// SIG // APZGoZ7RW4wmU+h6qkryRs83PDietHdcpReejcsRj1Y8
// SIG // wawJXwPTAgMBAAGjggFeMIIBWjAPBgNVHRMBAf8EBTAD
// SIG // AQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGCNxUBBAUCAwEA
// SIG // ATAjBgkrBgEEAYI3FQIEFgQU/dExTtMmipXhmGA7qDFv
// SIG // pjy82C0wGQYJKwYBBAGCNxQCBAweCgBTAHUAYgBDAEEw
// SIG // HwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8KuEKU5VZ5KQw
// SIG // UAYDVR0fBEkwRzBFoEOgQYY/aHR0cDovL2NybC5taWNy
// SIG // b3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvbWljcm9z
// SIG // b2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUFBwEBBEgwRjBE
// SIG // BggrBgEFBQcwAoY4aHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNyb3NvZnRSb290Q2VydC5j
// SIG // cnQwDQYJKoZIhvcNAQEFBQADggIBAFk5Pn8mRq/rb0Cx
// SIG // MrVq6w4vbqhJ9+tfde1MOy3XQ60L/svpLTGjI8x8UJiA
// SIG // IV2sPS9MuqKoVpzjcLu4tPh5tUly9z7qQX/K4QwXacul
// SIG // nCAt+gtQxFbNLeNK0rxw56gNogOlVuC4iktX8pVCnPHz
// SIG // 7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y4k74jKHK6BOl
// SIG // kU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wdzaKMvSeyeWNW
// SIG // RKJRzfnpo1hW3ZsCRUQvX/TartSCMm78pJUT5Otp56mi
// SIG // LL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q70eFW6NB4lhhc
// SIG // yTUWX92THUmOLb6tNEQc7hAVGgBd3TVbIc6YxwnuhQ6M
// SIG // T20OE049fClInHLR82zKwexwo1eSV32UjaAbSANa98+j
// SIG // Zwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKNMxZlHg6K3RDe
// SIG // ZPRvzkbU0xfpecQEtNP7LN8fip6sCvsTJ0Ct5PnhqX9G
// SIG // uwdgR2VgQE6wQuxO7bN2edgKNAltHIAxH+IOVN3lofvl
// SIG // RxCtZJj/UBYufL8FIXrilUEnacOTj5XJjdibIa4NXJzw
// SIG // oq6GaIMMai27dmsAHZat8hZ79haDJLmIz2qoRzEvmtzj
// SIG // cT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq/2mbluIQqBC0
// SIG // N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZoNAAAAAAAHDAN
// SIG // BgkqhkiG9w0BAQUFADBfMRMwEQYKCZImiZPyLGQBGRYD
// SIG // Y29tMRkwFwYKCZImiZPyLGQBGRYJbWljcm9zb2Z0MS0w
// SIG // KwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBDZXJ0aWZpY2F0
// SIG // ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1MzA5WhcNMjEw
// SIG // NDAzMTMwMzA5WjB3MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSEw
// SIG // HwYDVQQDExhNaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Ew
// SIG // ggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCf
// SIG // oWyx39tIkip8ay4Z4b3i48WZUSNQrc7dGE4kD+7Rp9FM
// SIG // rXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr6Hu97IkHD/cO
// SIG // BJjwicwfyzMkh53y9GccLPx754gd6udOo6HBI1PKjfpF
// SIG // zwnQXq/QsEIEovmmbJNn1yjcRlOwhtDlKEYuJ6yGT1VS
// SIG // DOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd++NIT8wi3U21S
// SIG // tEWQn0gASkdmEScpZqiX5NMGgUqi+YSnEUcUCYKfhO1V
// SIG // eP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68eeEExd8yb3zuD
// SIG // k6FhArUdDbH895uyAc4iS1T/+QXDwiALAgMBAAGjggGr
// SIG // MIIBpzAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBQj
// SIG // NPjZUkZwCu1A+3b7syuwwzWzDzALBgNVHQ8EBAMCAYYw
// SIG // EAYJKwYBBAGCNxUBBAMCAQAwgZgGA1UdIwSBkDCBjYAU
// SIG // DqyCYEBWJ5flJRP8KuEKU5VZ5KShY6RhMF8xEzARBgoJ
// SIG // kiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJk/IsZAEZFglt
// SIG // aWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jvc29mdCBSb290
// SIG // IENlcnRpZmljYXRlIEF1dGhvcml0eYIQea0WoUqgpa1M
// SIG // c1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BBhj9odHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9taWNyb3NvZnRyb290Y2VydC5jcmwwVAYIKwYBBQUH
// SIG // AQEESDBGMEQGCCsGAQUFBzAChjhodHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY3Jvc29mdFJv
// SIG // b3RDZXJ0LmNydDATBgNVHSUEDDAKBggrBgEFBQcDCDAN
// SIG // BgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wDRDbd6bStd9vO
// SIG // eVFNAbEudHFbbQwTq86+e4+4LtQSooxtYrhXAstOIBNQ
// SIG // md16QOJXu69YmhzhHQGGrLt48ovQ7DsB7uK+jwoFyI1I
// SIG // 4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mRKiQicPv2/OR4
// SIG // mS4N9wficLwYTp2OawpylbihOZxnLcVRDupiXD8WmIsg
// SIG // P+IHGjL5zDFKdjE9K3ILyOpwPf+FChPfwgphjvDXuBfr
// SIG // Tot/xTUrXqO/67x9C0J71FNyIe4wyrt4ZVxbARcKFA7S
// SIG // 2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGysOUzU9nm/qhh6
// SIG // YinvopspNAZ3GmLJPR5tH4LwC8csu89Ds+X57H2146So
// SIG // dDW4TsVxIxImdgs8UoxxWkZDFLyzs7BNZ8ifQv+AeSGA
// SIG // nhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU2DKATCYqSCRf
// SIG // WupW76bemZ3KOm+9gSd0BhHudiG/m4LBJ1S2sWo9iaF2
// SIG // YbRuoROmv6pH8BJv/YoybLL+31HIjCPJZr2dHYcSZAI9
// SIG // La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCleKuzoJZ1GtmS
// SIG // hxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/Jmu5J4PcBZW+J
// SIG // C33Iacjmbuqnl84xKf8OxVtc2E0bodj6L54/LlUWa8kT
// SIG // o/0xggSEMIIEgAIBATCBkDB5MQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQgQ29kZSBTaWdu
// SIG // aW5nIFBDQQITMwAAALARrwqL0Duf3QABAAAAsDAJBgUr
// SIG // DgMCGgUAoIGmMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3
// SIG // AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEV
// SIG // MCMGCSqGSIb3DQEJBDEWBBTRJqwavrXYBra23ty+KPxN
// SIG // OFqHVjBGBgorBgEEAYI3AgEMMTgwNqAcgBoAaABlAGEA
// SIG // cABPAGIAagBlAGMAdAAuAGoAc6EWgBRodHRwOi8vbWlj
// SIG // cm9zb2Z0LmNvbTANBgkqhkiG9w0BAQEFAASCAQCNvZJn
// SIG // LLrMbf7YoSgBsc8vOYOhw4KbCi2mzSDxVUPfnNRXlpTY
// SIG // zzNAPfvdts1rdHBZ00dMw1pwgR3MVxuE48BrfG9VdRT8
// SIG // o/XGMWn0jO7fVbiueUuaYbdMHHACKaZQLAWbrlLufKPK
// SIG // 7vpWXxvDGA+/ejlp4t0584oDJjN12MXVKQmhzWLqS2fW
// SIG // +i3F9ZMFZYGmWI/x8MGXkHgsWcuPQeoJvChT2CAIYWcS
// SIG // 3EqF9iRMAUcVmd9GxnPac204Wbx8Ldo1GjUxav/HAJ4d
// SIG // 6MCXZBxFrImq+iLNB9BOuf8nKJMmHX++bGBQ1h4f4MKM
// SIG // apN1IEaK+qxtl96ji0iqEPd6boNToYICHzCCAhsGCSqG
// SIG // SIb3DQEJBjGCAgwwggIIAgEBMIGFMHcxCzAJBgNVBAYT
// SIG // AlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQH
// SIG // EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xITAfBgNVBAMTGE1pY3Jvc29mdCBUaW1l
// SIG // LVN0YW1wIFBDQQIKYQKOQgAAAAAAHzAJBgUrDgMCGgUA
// SIG // oF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkq
// SIG // hkiG9w0BCQUxDxcNMTMwMzE1MDYzMzU5WjAjBgkqhkiG
// SIG // 9w0BCQQxFgQULvp1mNuVHbVdaNXUisFR0duna5owDQYJ
// SIG // KoZIhvcNAQEFBQAEggEAdf5oAkbcwpN+jseD9fTCTz4g
// SIG // Onj8UeIeG+vBa0/QHMx375nVS3twsxUzXm2sGU5eD3vx
// SIG // mZVoxMZRWycxxNnx4ScR1hBx1aHjQULzKHAVKL//MkPX
// SIG // 5O1igpZHTmobDL0Gf6p3s6zI6o2ezsjMqRUwFv5Lvoxd
// SIG // r0mbizq8ZOXeq28NyGPXeGch5iKguYHfWNWksrB+mZ5m
// SIG // N4OQds6BtKpP0qtp8eYezDixkU5oOax05XAM4Aq5SIzy
// SIG // 1OCft+t05RRFRnT6YktzN+QakIiw2+NKkXaZJN+mr1IF
// SIG // ZK1E08ffrTwf2EbbG2ixvSx1dnKV4LuZHUXvODPNmn7l
// SIG // lfzjEB5GjQ==
// SIG // End signature block
